package ru.uss.vstore.localserver;

import ru.uss.vstore.builder.ValidUFormBuilderV1;
import ru.uss.vstore.model.doc.EUFormType;
import ru.uss.vstore.model.uform.UFormInfo;
import ru.uss.vstore.model.uform.abstractuform.AbstractUForm;
import ru.uss.vstore.utils.UFormSignatureHelper;

import java.math.BigDecimal;

/**
 * Created by Ildar on 04.03.2016.
 */
public class CreateUForm {

    public static UFormInfo generate(String uFormTypeName) {
        EUFormType uFormType = EUFormType.valueOf(uFormTypeName);

        UFormInfo uformInfo = new UFormInfo();

        switch (uFormType) {
            case BALANCE:
                uformInfo.setuForm(generateBalance());
                break;
            case MANUFACTURE:
                uformInfo.setuForm(generateManufacture());
                break;
            case MOVEMENT:
                uformInfo.setuForm(generateMovement());
                break;
            case WRITE_OFF:
                uformInfo.setuForm(generateWriteOff());
                break;
            default:
                throw new IllegalArgumentException("Illegal uForm type " + uFormTypeName);
        }
        uformInfo.setuFormBody(UFormSignatureHelper.toXML(uformInfo.getuForm()));

        return uformInfo;
    }

    public static AbstractUForm generateBalance() {
/*
<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<v1:uttn xmlns:a="namespace.abstractUttn" xmlns:v1="namespace.v1">
    <date>02.12.2016</date>
    <number>10</number>
    <uttnTypeCode>BALANCE</uttnTypeCode>
    <products>
        <product>
            <catalogTruId>5</catalogTruId>
            <measureUnitCode>796</measureUnitCode>
            <quantity>1000</quantity>
            <price>50</price>
            <sum>50000.00</sum>
        </product>
    </products>
    <recipientStoreId>3</recipientStoreId>
    <recipientTin>120840010109</recipientTin>
    <senderStoreId>3</senderStoreId>
    <senderTin>120840010109</senderTin>
    <totalSum>50000</totalSum>
</v1:uttn>
*/
        return builder(EUFormType.BALANCE)
                .setTotalSum(new BigDecimal(50000))
                .addProduct()
                    .setCatalogTruId(5L)
                    .setMeasureUnitCode("796")
                    .setQuantity(new BigDecimal(1000))
                    .setPrice(new BigDecimal(50))
                    .setSum(new BigDecimal(50000))
                    .complete()
                .build();
    }

    public static AbstractUForm generateManufacture() {
/*
<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<v1:uttn xmlns:a="namespace.abstractUttn" xmlns:v1="namespace.v1">
    <date>02.12.2016</date>
    <number>200</number>
    <type>MANUFACTURE</type>
    <products>
        <product>
            <catalogTruId>5</catalogTruId>
            <measureUnitCode>796</measureUnitCode>
            <quantity>1000</quantity>
            <originCertificateCountryCode>KAZ</originCertificateCountryCode>
            <sum>0.00</sum>
        </product>
    </products>
    <recipientStoreId>3</recipientStoreId>
    <recipientTin>120840010109</recipientTin>
    <senderStoreId>3</senderStoreId>
    <senderTin>120840010109</senderTin>
    <totalSum>0</totalSum>
</v1:uttn>
*/
        return builder(EUFormType.MANUFACTURE)
                .setTotalSum(new BigDecimal(0))
                .addProduct()
                    .setCatalogTruId(5L)
                    .setMeasureUnitCode("796")
                    .setQuantity(new BigDecimal(1000))
                    .setSum(new BigDecimal(0))
                    .complete()
                .build();
    }

    public static AbstractUForm generateMovement() {
/*
<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<v1:uttn xmlns:a="namespace.abstractUttn" xmlns:v1="namespace.v1">
    <date>02.12.2016</date>
    <number>100</number>
    <uttnTypeCode>MOVEMENT</uttnTypeCode>
    <products>
        <product>
            <catalogTruId>5</catalogTruId>
            <measureUnitCode>796</measureUnitCode>
            <quantity>100</quantity>
            <sum>0.00</sum>
        </product>
    </products>
    <recipientStoreId>4</recipientStoreId>
    <recipientTin>120840010109</recipientTin>
    <senderStoreId>3</senderStoreId>
    <senderTin>120840010109</senderTin>
    <totalSum>0</totalSum>
</v1:uttn>
*/
        return builder(EUFormType.MOVEMENT)
                .setRecipientStoreId(4L)
                .setTotalSum(new BigDecimal(10000))
                .addProduct()
                    .setCatalogTruId(5L)
                    .setMeasureUnitCode("796")
                    .setQuantity(new BigDecimal(100))
                    .setSum(new BigDecimal(0))
                    .complete()
                .build();
    }

    public static AbstractUForm generateWriteOff() {
/*
<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<v1:uttn xmlns:a="namespace.abstractUttn" xmlns:v1="namespace.v1">
    <date>02.12.2016</date>
    <number>2</number>
    <uttnTypeCode>WRITE_OFF</uttnTypeCode>
    <products>
        <product>
            <catalogTruId>5</catalogTruId>
            <measureUnitCode>796</measureUnitCode>
            <quantity>200</quantity>
            <price>50</price>
            <sum>10000.00</sum>
        </product>
    </products>
    <senderStoreId>3</senderStoreId>
    <senderTin>120840010109</senderTin>
    <totalSum>10000</totalSum>
</v1:uttn>
*/
        return builder(EUFormType.WRITE_OFF)
                .setTotalSum(new BigDecimal(10000))
                .addProduct()
                    .setCatalogTruId(5L)
                    .setMeasureUnitCode("796")
                    .setQuantity(new BigDecimal(200))
                    .setPrice(new BigDecimal(50))
                    .setSum(new BigDecimal(10000))
                    .complete()
                .build();
    }

    private static ValidUFormBuilderV1 builder(EUFormType uttnType) {
        return ValidUFormBuilderV1.create()
                .setUttnTypeCode(uttnType)
                .setSenderTin("120840010109")
                .setSenderStoreId(3L)
                .setRecipientTin("120840010109")
                .setRecipientStoreId(3L);
    }

}
